//////////////////////////////////////////////////////////////////////////////
//  Copyright 2014 by Autodesk, Inc.  All rights reserved.
//
// This computer source code and related instructions and comments 
// are the unpublished confidential and proprietary information of 
// Autodesk, Inc. and are protected under applicable copyright and 
// trade secret law.  They may not be disclosed to, copied or used 
// by any third party without the prior written consent of Autodesk, Inc.
//////////////////////////////////////////////////////////////////////////////

/*globals $,jQuery,document, window, navigator*/

/*!
* ntp.content - Dynamic updates of new tab page content
*/

// Namespace
var ntp = ntp || {};
ntp.content = ntp.content || {};

/**
 * Load string table as json data
 */
ntp.content.applyLocalizedStrings = function(localizedStrings) {
    // Verify string data
    if (localizedStrings !== null) {
        // Load localized strings and initialize text elements
        $('*[data-text-id]').each(function() {
            var $element = $(this);
            $element.html(localizedStrings[$element.data('text-id')]);
        });

        $('*[data-text-map]').each(function() {
            var $element = $(this);
            var textMap = $element.data('text-map');
            $.each(textMap, function(index, value) {
                $element.attr(index, localizedStrings[value]);
            });
        });
    }
};
/**
 * Gets or sets the map from file type to thumbnail image
 */
ntp.content.thumbnail = (function() {
    var thumbnails = {};
    var defaultThumbnail = 'images/default_thumb.png';

    // Gets or sets the settings object.
    return function(param, param1) {
        if ( typeof param === 'string') {
            if ( typeof param1 === 'string') {
                // Setting value
                thumbnails[param] = param1;
            } else {
                // Getting value
                var thumbnail = thumbnails[param];

                if ( typeof thumbnail === 'string') {
                    return thumbnail;
                } else {
                    return defaultThumbnail;
                }
            }

        } else {
            $.error('Invalid paramters.');
        }
    };
})();

ntp.content.tryTab = (function () {
    var isEnabled = false;
    var isTrial = false;
    var productLine;
    var productRelease;
    var productLang;
    var daysLeft = 0;
    var country;
    var basicUrl = null;
    var settingUrl = null;
    var isLoaded = false;
    // Gets or sets the settings object.
    return {
        getLoaded: function () {
            return isLoaded;
        },

        setTrial: function (state) {
            isTrial = state;
        },
        
        getTrial: function () {
            return isTrial;
        },
        
        applySettings: function (settings, spec){
            if(typeof settings.widgets !== 'undefined' && typeof spec !== 'undefined'){
                if(typeof settings.widgets.itm !== 'undefined' && typeof spec.tryTab !== 'undefined' ){
                    if(typeof spec.tryTab.enabled === 'string' && spec.tryTab.enabled.toLowerCase() === 'yes'){
                        if(typeof settings.widgets.itm.BasicURL === 'string')
                            basicUrl = settings.widgets.itm.BasicURL;
                        if(typeof spec.tryTab.settingUrl === 'string')
                            settingUrl = spec.tryTab.settingUrl;

                        //Get product information that will be used by ITM page.
                        if(basicUrl !== null && settingUrl !== null)
                            ntp.acad.getProductInfoAsJSON().done(ntp.utils.makeCallback(this, 'refreshProductInfoWithJSON'));
                    }
                }
            }
        },
        
        //Get product information from native side.
        refreshProductInfoWithJSON: function (productInfo) {
            var data = $.parseJSON(productInfo);
            if (typeof data.retValue !== 'undefined')
                data = data.retValue; // hoist retValue if present 

            if (data.trial === true && data.productLine !== null &&
                    data.productRelease !== null && data.productLang !== null
                    && data.country !== null && data.daysleft >= 0) {
                $('#tab_try .placeholder').addClass('loading');
                //save product information
                isTrial = true;
                productLine = data.productLine;
                productRelease = data.productRelease;
                productLang = data.productLang.toLowerCase();
                country = data.country.toLowerCase();
                daysLeft = data.daysleft;
                //Load try tab setting
                $.ajax({
                    url : settingUrl,
                    dataType : 'jsonp',
                    jsonpCallback : 'tryTabCallback',
                    crossDomain : true,
                    timeout : 5000,
                    success : function(data) {
                        //get setting file from ITM server
                        //try to load ITM page.
                        ntp.content.tryTab.loadITMPage(data);
                    },
                    error : function(xhr, status, error) {
                        // Don't get settings file.
                        $('#tab_try .placeholder').removeClass('loading');
                    }
                });
            }
        },
        
        //Refresh page
        refreshTryTabWithJSON: function (licenseInfo) {
            var data = $.parseJSON(licenseInfo);
            if (typeof data.retValue !== 'undefined')
                data = data.retValue; // hoist retValue if present
            if (data.type !== 2) {
                if (isLoaded === true) {
                    ntp.page.tabs.removeVisibleTab('tab_try', 'tab_create');
                }
            }
            else {
                if (isLoaded === false && basicUrl !== null && settingUrl !== null){
                    ntp.acad.getProductInfoAsJSON().done(ntp.utils.makeCallback(this, 'refreshProductInfoWithJSON'));
                }
            }
        },
        
        loadITMPage: function (data) {
            //load ITM page into try tab.
            if (typeof data !== 'undefined') {
                if (typeof data.retValue !== 'undefined')
                    data = data.retValue; // hoist retValue if present
                if (data.enabled.toLowerCase() == "yes") {
                    if(data.country instanceof Array && data.language instanceof Array){
                        var isSupportCountry = false;
                        var isSupportLang = false;
                        for(var i = 0; i < data.country.length; i++){
                            if(data.country[i].toLowerCase() === country){
                                isSupportCountry = true;
                                for(var k = 0; k < data.language.length; k++){
                                    if(data.language[k].toLowerCase() === productLang){
                                        isSupportLang = true;
                                        break;
                                    }
                                }
                                break;
                            }
                        }
                    }
                    if (isSupportCountry && isSupportLang) {
                        var pageUrl = basicUrl + productLine + "/" + productRelease
                                + "/" + productLang + "?redirected2=1&d="
                                + daysLeft + "&country=" + country;
                        $('#try_page').attr("src", pageUrl);
    
                        // Change current tab into Try Tab
                        ntp.page.tabs.addVisibleTab("tab_try", true);
                        isLoaded = true;
                        // Move hidden try tab content to target place.
                        var $preloaditm = $('#preload_try');
                        if ($preloaditm !== null) {
                            $('#tab_try .placeholder').remove();
                            $('#tab_try .content').empty().append(
                                    $preloaditm.children());
                            $preloaditm.remove();
                        }
                    }
                }
            }
            if(!isLoaded)
                $('#tab_try .placeholder').removeClass('loading');
        }
    };
})();

/**
 * Updates of learn tab content
 */
ntp.content.learnTab = (function() {

    var prevTipImage = 'images/prev_tip.png';
    var nextTipImage = 'images/next_tip.png';
    var hilightedContents = {};
    var hasFeaturedVideo = false;
    var hasGetStartedVideo = false;
    var hasResource = false;
    var hasTip = false;
    var notificationNum = 0;
    var $footerBadge = null;
    var $tipsData = null;
    var hilight = (function () {
        return {
            createElement: function (linkurl, uploadTime) {
                return $('<span>').addClass('newcontent').addClass('hidden').data({
                    url: linkurl,
                    upload_time: new Date(uploadTime)
                });
            }
        };
    })();
    var loadVideoList = function ($list, videos) {
        $list.empty();

        $.each(videos, function (i, video) {
            var $preview = $('<div>').addClass('video_preview');
            $preview.append($('<img>').addClass('thumb').attr({
                src : video.thumb,
                alt : 'thumbnail'
            })).append($('<span>').addClass('overlay'));

            var $title = $('<div>').addClass('title').html(video.title);
            var $info = $('<div>').append($title, $('<div>').addClass('desc').html(video.description).append($('<div>').addClass('duration').html(video.duration)), $('<div>').css('clear', 'both'));

            var $item = $('<li>').append($preview, $info).data({
                url: video.video,
                title: video.title,
                upload_time: video.upload_time
            });
            $list.append($item);

            if (typeof video.video !== 'undefined' && typeof video.upload_time !== 'undefined') {
                var uploadTimeFromServer = new Date(video.upload_time);

                if (uploadTimeFromServer > ntp.video.releasetime) {
                    $preview.append(hilightedContents[video.video] = hilight.createElement(video.video, video.upload_time));
                }
            }

            $item.click(ntp.utils.makeCallbackWithArgs(ntp.video, 'showPlayer', $item));
        });
    };

    var urlIsHilightedContent = function (url) {
        if (typeof hilightedContents[url] !== 'undefined' && !hilightedContents[url].hasClass('hidden')) {
            return true;
        } else {
            return false;
        }
    };

    var updateSectionVideos = function (data) {
        if (typeof data.retValue !== 'undefined')
            data = data.retValue; // hoist retValue if present
        hasFeaturedVideo = (typeof data.featuredVideoList !== 'undefined');
        hasGetStartedVideo = (typeof data.videoListSmall !== 'undefined');
        
        //Getting started videos
        if (typeof data.videoListSmall === 'object' && data.videoListSmall.video instanceof Array) {
            if (typeof data.videoListSmall.title === 'string') {
                $('#getting_started h1').text(data.videoListSmall.title);
            }

            loadVideoList($('#getting_started ol'), data.videoListSmall.video);
        } else {
            var $gettingStarted = $("#getting_started");
            $gettingStarted.next().remove();
            $gettingStarted.remove();
        }
        //feature videos
        if (typeof data.featuredVideoList === 'object' && data.featuredVideoList.video instanceof Array) {
            if (typeof data.featuredVideoList.title === 'string') {
                $('#feature_videos h1').text(data.featuredVideoList.title);
            }

            loadVideoList($('#feature_videos ol'), data.featuredVideoList.video);
        } else {
            var $featureVideos = $('#feature_videos');
            $featureVideos.remove();
        }
        //If the Getting Started and Feature Videos are not there remove section
        if ($('#feature_videos').length === 0 && $('#getting_started').length === 0) {
            var $sectionVidoes = $('#section_videos');
            $sectionVidoes.next().remove();
            $sectionVidoes.remove();
        }
        //update video column height.
        ntp.page.layout.updateVideoSectionHeight();
    };

    var updateLearnTipsSection = function (data) {
        if (typeof data.retValue !== 'undefined')
            data = data.retValue; // hoist retValue if present
        if (typeof data.tipsData !== 'undefined') {
            $tipsData = data.tipsData;
            $tipsData.whichTip = "next";
            updateTip();
        }
    };

    function updateTip() {
        var RecentlyUpdatedUrls = [];
        // Read current tipID and date
        RecentlyUpdatedUrls.push("tipID");
        RecentlyUpdatedUrls.push("tipExpireDate");

        ntp.acad.getLearnContentStateListAsJSON(RecentlyUpdatedUrls).done(ntp.utils.makeCallback(ntp.content.learnTab, 'LoadCurrentTip'));
    };

    function mouseRolloverImageUpdate(currentImage) {
        var str = currentImage.src;
        if (str.search("images/mouseover_") == -1) {
            str = str.replace("images/", "images/mouseover_");
        }
        else {
            str = str.replace("images/mouseover_", "images/");
        }
        currentImage.src = str;
    };

    function getTipToDisplay(currentTipData, tips, whichTip) {
        var $getCurrent = false;
        var $iter = 1;
        var $index = 0;

        while ($index < tips.length) {
            if (tips[$index].disabled == "true") {
                $index++;
            } else {
                break;
            }
        }
        if (whichTip == "forcePrev") {
            $index = tips.length - 1;
            $iter = -1;
        }
        else {
            if (whichTip == "next") {
                var $currentDate = new Date();
                var $tipExpireDate = new Date(currentTipData.tipExpireDate);

                if ($currentDate < $tipExpireDate) {
                    $getCurrent = true;
                }
            }
        }

        var i = 0;
        var $tiptodispaly = tips[$index];

        while (i < tips.length) {
            if (tips[$index].disabled == "true") {
                $index = ($index + $iter + tips.length)%tips.length;
                i++;
                continue;
            }
            if ($getCurrent == true) {
                if (tips[$index].id == currentTipData.tipID) {
                    $tiptodispaly = tips[$index];
                    break;
                }
            }
            else {
                if ($iter > 0 && tips[$index].id > currentTipData.tipID) {
                    $tiptodispaly = tips[$index];
                    break;
                }
                else if ($iter < 0 && tips[$index].id < currentTipData.tipID) {
                    $tiptodispaly = tips[$index];
                    break;
                }
            }
            $index = ($index + $iter + tips.length)%tips.length;
            i++;
        }
        return $tiptodispaly;
    };

    function parseTipContent(tipContent) {
        var $tipContentNode = $('<p id="tipcontent" >');

        for (var i = 0; i < tipContent.length; i++) {
            if (tipContent[i].text !== 'undefined') {
                $tipContentNode.append(tipContent[i].text);
            }
            if (typeof tipContent[i].icon !== 'undefined' && tipContent[i].icon !== null) {
                var icon = new Image();
                icon.src = tipContent[i].icon;

                $tipContentNode.append(icon);
            }
            if (typeof tipContent[i].image !== 'undefined' && tipContent[i].image !== null) {
                // We always want image in a new para
                var $tipImageNode = $('<p>');
                var icon = new Image();
                icon.src = tipContent[i].image;
                $tipImageNode.append(icon);

                $tipContentNode.append($tipImageNode);
            }
        }

        return $tipContentNode;
    };

    var updateOnlineResource = function (data) {
        if (typeof data.retValue !== 'undefined')
            data = data.retValue; // hoist retValue if present
        if (data.onlineResources) {
            hasResource = true;
            var $onlineResources = $('#online_resources_box');
            if (data.onlineResources.title) {
                $('#section_resources h1.resources').text(data.onlineResources.title);
            }
            if (data.onlineResources.description) {
                $onlineResources.append($('<p>').text(data.onlineResources.description));
            }
            if (data.onlineResources.links instanceof Array) {
                var $list = $('<ol>').addClass('flex');
                $onlineResources.append($list);

                $.each(data.onlineResources.links, function (i, link) {

                    var $listItem = $('<li>').addClass('button').append($('<img>').attr({
                        src: link.banner,
                        alt: link.caption
                    })).append($('<p>').text(link.caption));

                    //Append the hilight span if its a new link
                    if ((typeof link.url !== 'undefined' || typeof link.helpTopicId !== 'undefined') && typeof link.upload_time !== 'undefined') {

                        var uploadTimeFromServer = new Date(link.upload_time);
                        if (uploadTimeFromServer > ntp.video.releasetime) {
                            {
                                if (typeof link.url !== 'undefined')
                                    $listItem.append(hilightedContents[link.url] = hilight.createElement(link.url, link.upload_time));
                                else
                                    $listItem.append(hilightedContents[link.helpTopicId] = hilight.createElement(link.helpTopicId, link.upload_time));
                            }
                        }
                    }

                    $list.append($listItem);

                    if (link.url) {
                        if (link.external === true) {
                            $listItem.click(function () {
                                ntp.utils.openExternalUrlWithBrowser(link.url);
                                var $lightBoxPanel = $('#lightbox_panel');
                                $lightBoxPanel.addClass('leave_autodesk');

                                if (urlIsHilightedContent(link.url) === true) {
                                    ntp.acad.updateLearnContentState(link.url, link.upload_time);
                                }
                            });
                        } else {
                            $listItem.click(function () {
                                ntp.acad.openUrlWithBrowser(link.url);

                                if (urlIsHilightedContent(link.url) === true) {
                                    ntp.acad.updateLearnContentState(link.url, link.upload_time);
                                }
                            });
                        }
                    } else if (typeof link.helpTopicId === 'string' && link.helpTopicId !== "") {
                        $listItem.click(function (e) {
                            ntp.acad.openUrlWithHelpBrowser(link.helpTopicId);
                            e.preventDefault();
                            if (urlIsHilightedContent(link.helpTopicId) === true) {
                                ntp.acad.updateLearnContentState(link.helpTopicId, link.upload_time);
                            }
                        });
                    }
                });
            }

            ntp.page.layout.updateOnlineResourceHeight();
        } else {
            var $sectionResources = $('#section_resourceslinks');
            $sectionResources.remove();
        }
    };

    return {
        // ntp.content.learnTab
        urlIsHilightedContent: urlIsHilightedContent,

        hilightNewLearnConents: function (registryRecords) {
            if (typeof registryRecords.retValue !== 'undefined')
                registryRecords = registryRecords.retValue; // hoist retValue if present
            for (var url in hilightedContents) {
                if (hilightedContents.hasOwnProperty(url) && typeof hilightedContents[url] !== 'undefined') {
                    if (typeof registryRecords[url] === 'undefined' ||
                        hilightedContents[url].data('upload_time') > new Date(registryRecords[url])) {
                            hilightedContents[url].removeClass('hidden');
                            notificationNum++;
                        }
                }
            }

            //Update badge showing number.
            $footerBadge.html(notificationNum.toString());
            if (notificationNum > 0) {
                $footerBadge.removeClass('hidden');
            }
        },

        handleNextTip: function () {
            $tipsData.whichTip = "forceNext";
            updateTip();
        },
        mouseRolloverImageUpdate: function (obj) {
            mouseRolloverImageUpdate(obj);
        },
        handlePrevTip: function () {
            $tipsData.whichTip = "forcePrev"
            updateTip();
        },
        
        changeMouseOverImage: function() {
            this.src = "images/mouseover_next_tip.png";
        },

        LoadCurrentTip: function (RegisteredInfo) {
            var $currentTipData = $.parseJSON(RegisteredInfo);
            if (typeof $currentTipData.retValue !== 'undefined')
                $currentTipData = $currentTipData.retValue; // hoist retValue if present

            if ($tipsData && typeof $tipsData.learnTips !== 'undefined') {
                hasTip = true;
                var $tipContainer = $('#tip_container');
                var $tipResources = $('#tip_resource_box');
                var $tipDiv = $('<div id="tipdiv" style="position:relative;padding-right:15px" >');
                var $tipHeader = $('#tip_header');

                // Add images only when whole page is reloaded, not with next/previous tip
                if ($tipsData.whichTip == "next") {
                    $tipHeader.append($('<img id="nextImage" class="tip_header" >').attr({
                        'src' : nextTipImage,
                        'onclick' : 'ntp.content.learnTab.handleNextTip()',
                        'onMouseOver': 'ntp.content.learnTab.mouseRolloverImageUpdate(this)',
                        'onMouseOut': 'ntp.content.learnTab.mouseRolloverImageUpdate(this)',
                        }));

                    $tipHeader.append($('<img id="prevImage" class="tip_header" >').attr({
                        'src' : prevTipImage,
                        'onclick' : 'ntp.content.learnTab.handlePrevTip()',
                        'onMouseOver': 'ntp.content.learnTab.mouseRolloverImageUpdate(this)',
                        'onMouseOut': 'ntp.content.learnTab.mouseRolloverImageUpdate(this)',
                        }));
                    $.when(ntp.deferred.strings).done(function() {
                        $('#nextImage').prop('title', ntp.utils.localize('learn_next_tip'));
                        $('#prevImage').prop('title', ntp.utils.localize('learn_prev_tip'));
                    });

                }

                if ($tipsData.title) {
                    $('#section_resources h1.tip').text($tipsData.title);
                }

                var $tipToDisplay = getTipToDisplay($currentTipData, $tipsData.learnTips, $tipsData.whichTip);

                if ($tipToDisplay.content) {
                    var $tipContentNode = parseTipContent($tipToDisplay.content);

                    $tipDiv.append($tipContentNode);

                    if (typeof $tipToDisplay.caption !== 'undefined') {
                        $tipDiv.append($('<a href="fakeurl" tabindex="-1">').text($tipToDisplay.caption).on("click", function (e) {

                            if (typeof $tipToDisplay.helpTopicId !== 'undefined' && $tipToDisplay.helpTopicId !== "")
                                ntp.acad.openUrlWithHelpBrowser($tipToDisplay.helpTopicId);
                            else if (typeof $tipToDisplay.url !== 'undefined' && $tipToDisplay.url !== "")
                                ntp.acad.openUrlWithBrowser($tipToDisplay.url);

                            e.preventDefault();
                        }));
                    }
                    $tipResources.empty();
                    $tipResources.append($tipDiv);

                    var $todayDate = new Date();
                    $todayDate.setHours(23);
                    $todayDate.setMinutes(59);
                    $todayDate.setSeconds(59);

                    $tipResources.data({
                        upload_time: new Date(),
                        tip_ID: $tipToDisplay.id,
                        tip_Expire_Date: $todayDate,
                    });

                    //Append the hilight span if the tip is never visited
                    if (typeof $tipToDisplay.content !== 'undefined') {

                        if ($currentTipData.tipID != $tipToDisplay.id) {
                            if ( typeof hilightedContents['tip'] == 'undefined') {
                                $tipContainer.append(hilightedContents['tip'] = hilight.createElement('tip', new Date()));
                            }
                            // Update the tip data as user see next or previous tip
                            if ($tipsData.whichTip !== "next") {
                                ntp.acad.updateLearnContentState('tip', new Date());
                                ntp.acad.updateLearnContentState('tipID', $tipToDisplay.id);
                                ntp.acad.updateLearnContentState('tipExpireDate', $todayDate);
                            }
                        }
                    }
                }
            }
            else {
                var $tipSection = $('#Section_tip');
                if (typeof $tipSection != 'undefined' && $tipSection != null)
                    $('#Section_tip').remove();
            }

        },

        hasFeaturedVideos: function() {
            return hasFeaturedVideo;
        },
        
        hasGetStartedVideos: function() {
            return hasGetStartedVideo;
        },
        
        hasOnlineResource: function() {
            return hasResource;
        },
        
        hasTips: function() {
            return hasTip;
        },

        updateLearnTipsData: function (data) {
            updateLearnTipsSection(data);
        },

        unhilightViewedLearnConents: function (registryRecords) {

            if (typeof registryRecords.retValue !== 'undefined')
                registryRecords = registryRecords.retValue; // hoist retValue if present

            if (typeof registryRecords['RecentViewed'] !== 'undefined' &&
                urlIsHilightedContent(registryRecords['RecentViewed']) === true) {

                if (registryRecords['RecentViewed'] === 'tip' && ntp.page.tabs.isTipContentsVisited() === false) {
                    hilightedContents[registryRecords['RecentViewed']].addClass('hidden');
                    notificationNum--;
                } else if (registryRecords['RecentViewed'] !== 'tip') {
                    hilightedContents[registryRecords['RecentViewed']].addClass('hidden');
                    notificationNum--;
                }
            }

            if (typeof registryRecords['tip'] !== 'undefined' && urlIsHilightedContent('tip') === true) {
                hilightedContents['tip'].addClass('hidden');
                notificationNum--;
            }
            //Update badge showing number.
            if ($footerBadge !== null) {
                $footerBadge.html(notificationNum.toString());
                if (notificationNum === 0) {
                    $footerBadge.addClass('hidden');
                }
            }
        },

        unhilightRecentViewed: function (RegisteredInfo) {
            this.unhilightViewedLearnConents($.parseJSON(RegisteredInfo));
        },

        hilightRecentUpdates: function (RegisteredInfo) {
            this.hilightNewLearnConents($.parseJSON(RegisteredInfo));
        },

        load: function(data) {

            if (typeof data.retValue !== 'undefined')
                data = data.retValue; // hoist retValue if present

            $footerBadge = $('#footer_learn_badge');

            //load A360 widget based on url.
            if (typeof data.url_connect_widget === 'string' && data.url_connect_widget !== "") {
                //Set url and try to load A360 widget
                ntp.widget.connect.setWidgetURL(data.url_connect_widget);
            }
            ntp.widget.connect.beginRefresh();

            if (typeof data.release_time === 'string') {
                ntp.video.releasetime = new Date(data.release_time);
            }
            if ( typeof data.videoWidth === 'number') {
                ntp.video.videoWidth = data.videoWidth;
            }
            if ( typeof data.videoHeight === 'number') {
                ntp.video.videoHeight = data.videoHeight;
            }

            if ( typeof data.videoListLarge === 'object' && data.videoListLarge.video instanceof Array) {
                if ( typeof data.videoListLarge.title === 'string') {
                    $('#section_whats_new h1').text(data.videoListLarge.title);
                }
                loadVideoList($('#section_whats_new ol'), data.videoListLarge.video);
            } else {
                var $sectionWhatsNew = $('#section_whats_new');
                $sectionWhatsNew.next().remove();
                $sectionWhatsNew.remove();
            }

            //update Section videos
            updateSectionVideos(data);

            //update online resource
            updateOnlineResource(data);

            //Hilight the Recently added learn contents.
            var RecentlyUpdatedUrls = [];
            for (var url in hilightedContents) {
                if (hilightedContents.hasOwnProperty(url))
                    RecentlyUpdatedUrls.push(url);
            }
            if (RecentlyUpdatedUrls.length > 0)
                ntp.acad.getLearnContentStateListAsJSON(RecentlyUpdatedUrls).done(ntp.utils.makeCallback(this, 'hilightRecentUpdates'));

        }
    };
})();

/**
 * Triggers update of content on events
 */
(function() {
    ntp.deferred.customization.done(function() {
        ntp.deferred.strings.done(function(data) {
            ntp.content.applyLocalizedStrings(data);
            ntp.deferred.localization.resolve();
        });
    });

    $.when(ntp.deferred.localization, ntp.deferred.customization).done(function() {
        
        $.when.apply(null, ntp.asyncLoadings).always(function() {
            ntp.widget.notifications.adjustContainerHeight();
            $('#preload_mask').remove();
        });

        // Load the content of learn tab
        ntp.deferred.learnTab.done(function(data) {

            ntp.widget.connect.setIsOnline(true);
            ntp.content.learnTab.load(data);

            // Move hidden learn tab content to target place.
            var $preloadLearn = $('#preload_learn');
            $('#tab_learn .placeholder').remove();
            $('#tab_learn .content').empty().append($preloadLearn.children());
            $preloadLearn.remove();

            ntp.page.tabs.addVisibleTab("tab_learn", false);
            ntp.page.layout.update(); 
        }).fail(function() {
            // Show offine help download notification box when load learn page failure.
            ntp.widget.notifications.beginGetOfflineHelpStatus();
            ntp.widget.connect.setIsOnline(false);
            ntp.widget.connect.beginRefresh();
        });
    });
})();

// SIG // Begin signature block
// SIG // MIIZ4gYJKoZIhvcNAQcCoIIZ0zCCGc8CAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // A9bD2TQeVSXQsTb8WiBJLhTdPvt6gUz04JlvnFA5Qwug
// SIG // ggpSMIIFAzCCA+ugAwIBAgIQdnK0JhTS6n5kEFOlgziE
// SIG // ljANBgkqhkiG9w0BAQsFADCBhDELMAkGA1UEBhMCVVMx
// SIG // HTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8w
// SIG // HQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMTUw
// SIG // MwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
// SIG // b2RlIFNpZ25pbmcgQ0EgLSBHMjAeFw0xNjA4MDgwMDAw
// SIG // MDBaFw0xNzA5MDIyMzU5NTlaMIGIMQswCQYDVQQGEwJV
// SIG // UzETMBEGA1UECAwKQ2FsaWZvcm5pYTETMBEGA1UEBwwK
// SIG // U2FuIFJhZmFlbDEWMBQGA1UECgwNQXV0b2Rlc2ssIElu
// SIG // YzEfMB0GA1UECwwWRGVzaWduIFNvbHV0aW9ucyBHcm91
// SIG // cDEWMBQGA1UEAwwNQXV0b2Rlc2ssIEluYzCCASIwDQYJ
// SIG // KoZIhvcNAQEBBQADggEPADCCAQoCggEBAOqZ9OjPzARq
// SIG // d9dP4fq2qXdpTJolFYJ8Wxg8WcZVciX3l+dljew4R9C8
// SIG // WR/0tW17lLANaSORF4IYmWTgdpFg5PGR3s+R4A461hpR
// SIG // IG9QthGUq8Bt7af5VbCjjKtYBNq/x3ukqVsw/1/qljGV
// SIG // plDOyr976ktnCm0/wL0N+ubk5WAIgv+I9E0i6+GX1hRm
// SIG // +eRliYKeKF0/gBLyDh3ut+N3HNPrnfjfec7q2Czd82Ce
// SIG // RBCToR1E7Cp6yBBdGUfb3JE0PnE1+6n0qJnsvs2bsCIz
// SIG // qVo3A0iMHBsbioxa5DYyXuEfNCktosUlFXfegd514ZJn
// SIG // s6YDr4PlahC0+lK3hgJy5vkCAwEAAaOCAWkwggFlMAkG
// SIG // A1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQM
// SIG // MAoGCCsGAQUFBwMDMGEGA1UdIARaMFgwVgYGZ4EMAQQB
// SIG // MEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5zeW1jYi5j
// SIG // b20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5z
// SIG // eW1jYi5jb20vcnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL
// SIG // 3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIwIKAeoByGGmh0
// SIG // dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUF
// SIG // BwEBBEswSTAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5
// SIG // bWNkLmNvbTAmBggrBgEFBQcwAoYaaHR0cDovL3JiLnN5
// SIG // bWNiLmNvbS9yYi5jcnQwEQYJYIZIAYb4QgEBBAQDAgQQ
// SIG // MBYGCisGAQQBgjcCARsECDAGAQEAAQH/MA0GCSqGSIb3
// SIG // DQEBCwUAA4IBAQDAO29k596Wq5ympOToYLmaRc7ZeGvY
// SIG // x6j5lNWmwCC9ACLTN+mqXF1msf5KtHRHTpyLFVDH/zCC
// SIG // 3LrRzHSHuflhkKFlhJQsEttZ3rhmKxlEtJ85Id9pA8wm
// SIG // XN+Q5tKIStReWLsZ2eA15G9BEFmPvq5DAFj0h+LNF6hq
// SIG // 87C2bVqim29Kf9wDMp3Ndd7hj07QEVh7CqCKEoAJYvXR
// SIG // BBAdrMTqjCTtYCwDkAaAg5LdEm5w76jCQkR2XzKOTgDl
// SIG // qa9uQIyQBAc2ci6X9OBdGJw0ZM0JDlEkRpr3uODtZIOn
// SIG // UQQchI+k+cwEAK7+vFhfsLBi7Dyt1mbvfINr803cFja3
// SIG // i5JOMIIFRzCCBC+gAwIBAgIQfBs1NUrn23TnQV8Racpr
// SIG // qDANBgkqhkiG9w0BAQsFADCBvTELMAkGA1UEBhMCVVMx
// SIG // FzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMR8wHQYDVQQL
// SIG // ExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMTowOAYDVQQL
// SIG // EzEoYykgMjAwOCBWZXJpU2lnbiwgSW5jLiAtIEZvciBh
// SIG // dXRob3JpemVkIHVzZSBvbmx5MTgwNgYDVQQDEy9WZXJp
// SIG // U2lnbiBVbml2ZXJzYWwgUm9vdCBDZXJ0aWZpY2F0aW9u
// SIG // IEF1dGhvcml0eTAeFw0xNDA3MjIwMDAwMDBaFw0yNDA3
// SIG // MjEyMzU5NTlaMIGEMQswCQYDVQQGEwJVUzEdMBsGA1UE
// SIG // ChMUU3ltYW50ZWMgQ29ycG9yYXRpb24xHzAdBgNVBAsT
// SIG // FlN5bWFudGVjIFRydXN0IE5ldHdvcmsxNTAzBgNVBAMT
// SIG // LFN5bWFudGVjIENsYXNzIDMgU0hBMjU2IENvZGUgU2ln
// SIG // bmluZyBDQSAtIEcyMIIBIjANBgkqhkiG9w0BAQEFAAOC
// SIG // AQ8AMIIBCgKCAQEA15VD1NzfZ645+1KktiYxBHDpt45b
// SIG // Kro3aTWVj7vAMOeG2HO73+vRdj+KVo7rLUvwVxhOsY2l
// SIG // M9MLdSPVankn3aPT9w6HZbXerRzx9TW0IlGvIqHBXUuQ
// SIG // f8BZTqudeakC1x5JsTtNh/7CeKu/71KunK8I2TnlmlE+
// SIG // aV8wEE5xY2xY4fAgMxsPdL5byxLh24zEgJRyu/ZFmp7B
// SIG // JQv7oxye2KYJcHHswEdMj33D3hnOPu4Eco4X0//wsgUy
// SIG // GUzTsByf/qV4IEJwQbAmjG8AyDoAEUF6QbCnipEEoJl4
// SIG // 9He082Aq5mxQBLcUYP8NUfSoi4T+IdpcXn31KXlPsER0
// SIG // b21y/wIDAQABo4IBeDCCAXQwLgYIKwYBBQUHAQEEIjAg
// SIG // MB4GCCsGAQUFBzABhhJodHRwOi8vcy5zeW1jZC5jb20w
// SIG // EgYDVR0TAQH/BAgwBgEB/wIBADBmBgNVHSAEXzBdMFsG
// SIG // C2CGSAGG+EUBBxcDMEwwIwYIKwYBBQUHAgEWF2h0dHBz
// SIG // Oi8vZC5zeW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBka
// SIG // F2h0dHBzOi8vZC5zeW1jYi5jb20vcnBhMDYGA1UdHwQv
// SIG // MC0wK6ApoCeGJWh0dHA6Ly9zLnN5bWNiLmNvbS91bml2
// SIG // ZXJzYWwtcm9vdC5jcmwwEwYDVR0lBAwwCgYIKwYBBQUH
// SIG // AwMwDgYDVR0PAQH/BAQDAgEGMCkGA1UdEQQiMCCkHjAc
// SIG // MRowGAYDVQQDExFTeW1hbnRlY1BLSS0xLTcyNDAdBgNV
// SIG // HQ4EFgQU1MAGIknrOUvdk+JcobhHdglyA1gwHwYDVR0j
// SIG // BBgwFoAUtnf6aUhHn1MS1cLqBzJ2B9GXBxkwDQYJKoZI
// SIG // hvcNAQELBQADggEBAH/ryqfqi3ZC6z6OIFQw47e53PpI
// SIG // PhbHD0WVEM0nhqNm8wLtcfiqwlWXkXCD+VJ+Umk8yfHg
// SIG // lEaAGLuh1KRWpvMdAJHVhvNIh+DLxDRoIF60y/kF7Zyv
// SIG // cFMnueg+flGgaXGL3FHtgDolMp9Er25DKNMhdbuX2IuL
// SIG // jP6pBEYEhfcVnEsRjcQsF/7Vbn+a4laS8ZazrS359N/a
// SIG // iZnOsjhEwPdHe8olufoqaDObUHLeqJ/UzSwLNL2LMHhA
// SIG // 4I2OJxuQbxq+CBWBXesv4lHnUR7JeCnnHmW/OO8BSgEJ
// SIG // JA4WxBR5wUE3NNA9kVKUneFo7wjw4mmcZ26QCxqTcdQm
// SIG // AsPAWiMxgg7oMIIO5AIBATCBmTCBhDELMAkGA1UEBhMC
// SIG // VVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9u
// SIG // MR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3Jr
// SIG // MTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1
// SIG // NiBDb2RlIFNpZ25pbmcgQ0EgLSBHMgIQdnK0JhTS6n5k
// SIG // EFOlgziEljANBglghkgBZQMEAgEFAKB8MBAGCisGAQQB
// SIG // gjcCAQwxAjAAMBkGCSqGSIb3DQEJAzEMBgorBgEEAYI3
// SIG // AgEEMBwGCisGAQQBgjcCAQsxDjAMBgorBgEEAYI3AgEV
// SIG // MC8GCSqGSIb3DQEJBDEiBCCjOBNhmry0NrEQP9BEEASE
// SIG // Y4wKVdPWDIzbx72HZ3HeeTANBgkqhkiG9w0BAQEFAASC
// SIG // AQCz3MbW4jVquVrMcA2yVaIB/GQB5a02Gzg+9P8EKa3z
// SIG // OQtVjt+GRp3pl2fkvbZZU3BoEc2BQTaSIpEj5CQxMsoQ
// SIG // AbsRJEuUIAq79UQj2+fclvJ5QjbKf+qSsn8LpVbFUQTR
// SIG // ttGhTrfVHTJtuJ6ktsYfGAEIPs1aVdspAyrD4LsuY44z
// SIG // HlmTY8k9k2YU7CqHAg6lvNbNg8HA4lNcdGKhfYKBKn/K
// SIG // 9FrjVMZ9rpUlNqHq+hF5H3COJ+zL8eMgsP4VzHqrurgR
// SIG // VdAisvCO/kkT/DLAuUllIYaE25OWU4meI/X0FkOEi9Uq
// SIG // dU9TFy+4pODC3pArYOilDx8ZMimUvLRReVjcoYIMoTCC
// SIG // DJ0GCisGAQQBgjcDAwExggyNMIIMiQYJKoZIhvcNAQcC
// SIG // oIIMejCCDHYCAQMxDzANBglghkgBZQMEAgEFADCB3QYL
// SIG // KoZIhvcNAQkQAQSggc0EgcowgccCAQEGCSsGAQQBoDIC
// SIG // AzAxMA0GCWCGSAFlAwQCAQUABCBXFE3ZFPIucXLuZhGv
// SIG // O+OHxuVZdbw6Wxx34j3y7wS3sgIUFMNmfQ2+cPuY77lL
// SIG // 4Rs9E5/avy0YDzIwMTcwMjAzMDQ1MDM0WqBdpFswWTEL
// SIG // MAkGA1UEBhMCU0cxHzAdBgNVBAoTFkdNTyBHbG9iYWxT
// SIG // aWduIFB0ZSBMdGQxKTAnBgNVBAMTIEdsb2JhbFNpZ24g
// SIG // VFNBIGZvciBBZHZhbmNlZCAtIEcyoIIIxjCCBKkwggOR
// SIG // oAMCAQICEhEhBvEPzmjwm/rlWxjNjyABdzANBgkqhkiG
// SIG // 9w0BAQsFADBbMQswCQYDVQQGEwJCRTEZMBcGA1UEChMQ
// SIG // R2xvYmFsU2lnbiBudi1zYTExMC8GA1UEAxMoR2xvYmFs
// SIG // U2lnbiBUaW1lc3RhbXBpbmcgQ0EgLSBTSEEyNTYgLSBH
// SIG // MjAeFw0xNjA1MjQwMDAwMDBaFw0yNzA2MjQwMDAwMDBa
// SIG // MFkxCzAJBgNVBAYTAlNHMR8wHQYDVQQKExZHTU8gR2xv
// SIG // YmFsU2lnbiBQdGUgTHRkMSkwJwYDVQQDEyBHbG9iYWxT
// SIG // aWduIFRTQSBmb3IgQWR2YW5jZWQgLSBHMjCCASIwDQYJ
// SIG // KoZIhvcNAQEBBQADggEPADCCAQoCggEBALfHkooo2POR
// SIG // y1ANXespRMGCWaXKZM69g7VR5ZTMboCaF2zc/2LmNkNe
// SIG // AcIMZI3Kd572XXdFuV7IJOtBNxFmN6zIzXSbzLPvTOJ/
// SIG // G85zvsmWnTUefPdU92zsoBLWrpmdY8R4X1mpLiL1wyfY
// SIG // sltFYyeQ/4yxPam08w7A8SBlBomdAxyjsFJBhTTrvMvO
// SIG // VPYS/rMBiUqm+lTFH/vTHMDjv5fjP9Ab+UDHG9XrJnxD
// SIG // MMdw8ngRqoVOpQ4NAEo6EXejyiMBgJ7Ik1ZdRsyK2NKq
// SIG // CoSFsolb1TLOQXsYTlTKq9FSXhLTJJ5W8wyP3b2SjnnV
// SIG // QYnDo6DlkfzHZ52HM85xMnMCAwEAAaOCAWcwggFjMA4G
// SIG // A1UdDwEB/wQEAwIHgDBMBgNVHSAERTBDMEEGCSsGAQQB
// SIG // oDIBHjA0MDIGCCsGAQUFBwIBFiZodHRwczovL3d3dy5n
// SIG // bG9iYWxzaWduLmNvbS9yZXBvc2l0b3J5LzAJBgNVHRME
// SIG // AjAAMBYGA1UdJQEB/wQMMAoGCCsGAQUFBwMIMEYGA1Ud
// SIG // HwQ/MD0wO6A5oDeGNWh0dHA6Ly9jcmwuZ2xvYmFsc2ln
// SIG // bi5jb20vZ3MvZ3N0aW1lc3RhbXBpbmdzaGEyZzIuY3Js
// SIG // MFgGCCsGAQUFBwEBBEwwSjBIBggrBgEFBQcwAoY8aHR0
// SIG // cDovL3NlY3VyZS5nbG9iYWxzaWduLmNvbS9jYWNlcnQv
// SIG // Z3N0aW1lc3RhbXBpbmdzaGEyZzIuY3J0MB0GA1UdDgQW
// SIG // BBQtbm7RjeUDgO7nY+mn2doLPFciPTAfBgNVHSMEGDAW
// SIG // gBSSIadKlV1ksJu0HuYAN0fmnUErTDANBgkqhkiG9w0B
// SIG // AQsFAAOCAQEAV51T5N3upSze5L9igKJhhkqfm50kIzCb
// SIG // jyeHL/oEWc5wiD1GUnfEm0XSj723IRhJ2C6H/5Iud/k/
// SIG // CvmgIVwTT+SEKyiHzFwVuROr4hJVw/hFHkkZzqp1DyHo
// SIG // 71H8NCwLMgUJsuQWaa3ZLn7h/C1IvxrTdDUBOt8wQ3Bn
// SIG // ejjXuhHCVvsxSLpb8SESYuB2iZEfSTjUWE15CYqp2m8C
// SIG // 1q3k2ol9TNmxMHBAattFulN2kNxLQhYhz+TSWJTUVWWb
// SIG // dgOsrhgItoMSjEE+X4BFZMiJ1DMXoaFMvT/Ekv5/hfK+
// SIG // sazX9p7LzhMq7gJDT/z/cDU0ozN8z+INMiQgfAA+ozIR
// SIG // 3jCCBBUwggL9oAMCAQICCwQAAAAAATGJxlAEMA0GCSqG
// SIG // SIb3DQEBCwUAMEwxIDAeBgNVBAsTF0dsb2JhbFNpZ24g
// SIG // Um9vdCBDQSAtIFIzMRMwEQYDVQQKEwpHbG9iYWxTaWdu
// SIG // MRMwEQYDVQQDEwpHbG9iYWxTaWduMB4XDTExMDgwMjEw
// SIG // MDAwMFoXDTI5MDMyOTEwMDAwMFowWzELMAkGA1UEBhMC
// SIG // QkUxGTAXBgNVBAoTEEdsb2JhbFNpZ24gbnYtc2ExMTAv
// SIG // BgNVBAMTKEdsb2JhbFNpZ24gVGltZXN0YW1waW5nIENB
// SIG // IC0gU0hBMjU2IC0gRzIwggEiMA0GCSqGSIb3DQEBAQUA
// SIG // A4IBDwAwggEKAoIBAQCqm47DqxFRJQG2lpTiT9jBCPZG
// SIG // I9lFxZWXW6sav9JsV8kzBh+gD8Y8flNIer+dh56v7sOM
// SIG // R+FC7OPjoUpsDBfEpsG5zVvxHkSJjv4L3iFYE+5NyMVn
// SIG // Cxyys/E0dpGiywdtN8WgRyYCFaSQkal5ntfrV50rfCLY
// SIG // FNfxBx54IjZrd3mvr/l/jk7htQgx/ertS3FijCPxAzmP
// SIG // RHm2dgNXnq0vCEbc0oy89I50zshoaVF2EYsPXSRbGVQ9
// SIG // JsxAjYInG1kgfVn2k4CO+Co4/WugQGUfV3bMW44ETyyo
// SIG // 24RQE0/G3Iu5+N1pTIjrnHswJvx6WLtZvBRykoFXt3bJ
// SIG // 2IAKgG4JAgMBAAGjgegwgeUwDgYDVR0PAQH/BAQDAgEG
// SIG // MBIGA1UdEwEB/wQIMAYBAf8CAQAwHQYDVR0OBBYEFJIh
// SIG // p0qVXWSwm7Qe5gA3R+adQStMMEcGA1UdIARAMD4wPAYE
// SIG // VR0gADA0MDIGCCsGAQUFBwIBFiZodHRwczovL3d3dy5n
// SIG // bG9iYWxzaWduLmNvbS9yZXBvc2l0b3J5LzA2BgNVHR8E
// SIG // LzAtMCugKaAnhiVodHRwOi8vY3JsLmdsb2JhbHNpZ24u
// SIG // bmV0L3Jvb3QtcjMuY3JsMB8GA1UdIwQYMBaAFI/wS3+o
// SIG // LkUkrk1Q+mOai97i3Ru8MA0GCSqGSIb3DQEBCwUAA4IB
// SIG // AQAEVoJKfNDOyb82ZtG+NZ6TbJfoBs4xGFn5bEFfgC7A
// SIG // QiW4GMf81LE3xGigzyhqA3RLY5eFd2E71y/j9b0zopJ9
// SIG // ER+eimzvLLD0Yo02c9EWNvG8Xuy0gJh4/NJ2eejhIZTg
// SIG // H8Si4apn27Occ+VAIs85ztvmd5Wnu7LL9hmGnZ/I1JgF
// SIG // snFvTnWu8T1kajteTkamKl0IkvGj8x10v2INI4xcKjiV
// SIG // 0sDVzc+I2h8otbqBaWQqtaai1XOv3EbbBK6R127FmLrU
// SIG // R8RWdIBHeFiMvu8r/exsv9GU979Q4HvgkP0gGHgYIl0I
// SIG // LowcoJfzHZl9o52R0wZETgRuehwg4zbwtlC5MYICtDCC
// SIG // ArACAQEwcTBbMQswCQYDVQQGEwJCRTEZMBcGA1UEChMQ
// SIG // R2xvYmFsU2lnbiBudi1zYTExMC8GA1UEAxMoR2xvYmFs
// SIG // U2lnbiBUaW1lc3RhbXBpbmcgQ0EgLSBTSEEyNTYgLSBH
// SIG // MgISESEG8Q/OaPCb+uVbGM2PIAF3MA0GCWCGSAFlAwQC
// SIG // AQUAoIIBFDAaBgkqhkiG9w0BCQMxDQYLKoZIhvcNAQkQ
// SIG // AQQwHAYJKoZIhvcNAQkFMQ8XDTE3MDIwMzA0NTAzNFow
// SIG // LwYJKoZIhvcNAQkEMSIEIM69Li0BTyJqQFMDl3d3vmrT
// SIG // 0TO0wApnPsMTYFwYGaEDMIGmBgsqhkiG9w0BCRACDDGB
// SIG // ljCBkzCBkDCBjQQUfVXY51pWovxzgkP3uFSHXFy1Kg0w
// SIG // dTBfpF0wWzELMAkGA1UEBhMCQkUxGTAXBgNVBAoTEEds
// SIG // b2JhbFNpZ24gbnYtc2ExMTAvBgNVBAMTKEdsb2JhbFNp
// SIG // Z24gVGltZXN0YW1waW5nIENBIC0gU0hBMjU2IC0gRzIC
// SIG // EhEhBvEPzmjwm/rlWxjNjyABdzANBgkqhkiG9w0BAQEF
// SIG // AASCAQCSdgiXjcSe+8w+CsKFyqbNXXQx5DiijJBRrrWa
// SIG // QqiUQ2H9fIKrRNxaeMXcQRRXW2K8Aj9Df1i745XUpMC1
// SIG // AFWdjOcatVGZobfNeF6lOBuHEx8R2A+GNDwgwQVh23LU
// SIG // 02ceRT5Rs9E6sAOttoWA8OtTKzO5FAaE0mX9pAzJ/TQS
// SIG // Etue8ICW5d+fZkelxG/bYZaDR0kBQqk0T2Bt/k5LGkI2
// SIG // VHpHr6NzY5jvH9+XpzvP3PbHSxXiUog0Rri6PZ2zvMss
// SIG // Os0If9IWfS9kID77XzNzc9JZDNbXtM6fUPiiHNB3b//O
// SIG // uRPe/QY4kCO4Qn7Lx/ulx7NjLSSvrZ4Rxa04G38W
// SIG // End signature block
